﻿<?LassoScript

lasso_errorreporting: 'minimal', -local;

if:(action_param:'WSDL', -count);
	include:lassoapp_link:'LassoService.wsdl.lasso';
else:(action_param:'XSD', -count);
	content_type:'text/xml';
	string($lp7_types.xsd, -encodenone);
else:client_headers >> 'SOAPAction:';
	include:lassoapp_link:'soap_handler.lasso';
else:client_contenttype->beginsWith('text/xml');

    local:'post' = @client_postargs;

	content_type:'text/xml';
	protect;
        local:'rpc'=xml_rpc:#post;
        
        local:'tag' = #rpc->getMethod;
        local:'found'= @($__RPC__->(find:#tag));
 
        fail_if: #found == null, -1, 'The method was not found.';
    
        local:'response' = #found->(run:-params=(#rpc->getParams));

        $__HTML_REPLY__ = 
            (xml_rpc:(
                #response
                    ))->(response:-full=false, -fault=false);
        
        handle_error;
            $__HTML_REPLY__ = (xml_rpc:(array: -faultCode=(error_currenterror:-errorcode), -faultString=(error_currenterror)))->(response: -full=false, -fault=true);
        /handle_error;
	/protect;
	
else: (lasso_tagexists: 'encode_json') && (lasso_tagexists: 'decode_json') && client_postargs->beginswith('{');

	//
	// JSON-RPC Support
	//
	// JSON-RPC requests are handled automatically if the [Encode_JSON]
	// and [Decode_JSON] tags are defined.  Note that only a single
	// request is evaluated and only HTTP is supported.
	//
	// Originally introduced in a Tip of the Week:
	//
	// <http://www.lassosoft.com/Documentation/TotW/index.lasso?9319>
	//
	
	local: 'response' = (map: 'error'=null, 'result'=null, 'id'=null);
	protect;
		local: 'request' = (decode_json: client_postargs);
		fail_if: #request !>> 'method', -1, 'No method was specified.';
		local: 'found' = @($__RPC__->(find: #request->(find: 'method')));
        fail_if: #found == null, -1, 'The method was not found.';
		#response->(insert: 'id' = #request->(find: 'id'));
		Local: 'params' = (if_null: #request->(find: 'params'), array);
        #response->(insert: 'result' = #found->(run:-params=(#params)));
        handle_error;
        	#response->(insert: 'error'=(Map: 'code'=error_code, 'msg'=error_msg));
        /handle_error;
	/protect;
	$__HTML_REPLY__ = (Encode_JSON: #response);

/if;

?>